
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>  /* may need <varargs.h> for Unix V */
#include <direct.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <windows.h>

#ifdef   _MSC_VER
#define  MY_SLASH  "\\"
#define  MY_IFDIR  _S_IFDIR
#else /* !_MSC_VER */
#define  MY_SLASH  "/"
#define  MY_IFDIR  S_IFDIR
#endif /* _MSC_VER y/n */
#define  MY_NAME_MAX 264

#define  CHKMEM(a) if(!a){ printf( "ERROR: Memory FAILED!\n" ); pgm_exit(-1); }

int   g_do_delete = 0;
char * g_dir = 0;
unsigned long g_dir_count = 0;
unsigned long g_file_count = 0;
LONGLONG g_total_size = 0;

struct _MYLIST;
typedef struct _MYLIST MYLIST;
typedef MYLIST * PMYLIST;
struct _MYLIST {
   PMYLIST pnext;
   int     done;
   char    name[1];
};



typedef struct _MyDir MyDir;
typedef struct tagMyDirEnt
{
  char de_name[ MY_NAME_MAX+1 ];
  long de_size;
  time_t de_time;
  int de_isdir;
}MyDirEnt;

struct _MyDir
{
  char td_dirname[MY_NAME_MAX+1]; /* current folder being scanned */
  MyDirEnt td_curr; /* current entry in folder */
#ifdef _MSC_VER
  char td_search[MY_NAME_MAX+1]; /* search name */
  WIN32_FIND_DATA td_data; /* search data */
  HANDLE td_hFind; /* find handle */
  int td_first;  /* set for first item */
  int td_done;   /* no more entries */
#else
  DIR * td_pdir;
#endif
};

struct stat g_stat_buf;
int MyDirExists( char * dirname )
{
   // check if entry is a directory
   if( stat( dirname, &g_stat_buf) == 0 ) {
      if( g_stat_buf.st_mode & MY_IFDIR ) {
         return 1;
      }
   }
   /* set g_stat_buf.st_atime; and g_stat_buf.st_size; */

   return 0;
}

MyDir * MyOpenDir( char * dirnm )
{
   MyDir * tdir = malloc( sizeof(MyDir) );
   if (tdir != NULL )
   {
      strcpy( tdir->td_dirname, dirnm ) ;
#ifdef _MSC_VER
      {
         size_t len;
         strcpy(tdir->td_search, dirnm);
       
         /* remove any trailing directory separator */
         len = strlen(tdir->td_search);
         if( ( len > 0 ) && strchr( "/\\", tdir->td_search[len-1]) ) {
            /* remove trailing SLASH, of either type */
            tdir->td_search[len-1] = 0;
            /* from BOTH */
            tdir->td_dirname[len-1] = 0;
         }
         /* add the wild card for ALL */
         strcat( tdir->td_search, MY_SLASH"*.*" );

         tdir->td_first = 1; /* set FIRST available ... */
         tdir->td_done = 0;  /* not DONE yet ... */
         tdir->td_hFind = FindFirstFile( tdir->td_search, &tdir->td_data);
         if( tdir->td_hFind == INVALID_HANDLE_VALUE )
         {
            free(tdir); /* not directory */
            tdir = NULL;
         }
      }
#else
      tdir->td_pdir = opendir(dirnm);
      if( tdir->td_pdir == NULL )
      {
         free(tdir);
         tdir = NULL;
      }
#endif
   }
   return tdir;
}

MyDirEnt * MyReadDir( MyDir * tdir )
{
   static char _dir_path[1000 + MY_NAME_MAX];
   static struct stat _s_buf;

   // get next entry from the directory
#ifdef _MSC_VER
   // check state
   if( tdir->td_first ) {
      tdir->td_first = 0;
   } else if ( !tdir->td_done &&
      !FindNextFile( tdir->td_hFind, &tdir->td_data ) ) {
      tdir->td_done = 1;
   }

   if( tdir->td_done )
      return NULL;

   /* get current entry from structure */
   strcpy( tdir->td_curr.de_name, tdir->td_data.cFileName );
#else /* !_MSC_VER */
   struct dirent * pdirent = readdir( tdir->td_pdir );

   if( !pdirent )
      return NULL;

   strcpy( tdir->td_curr.de_name, pdirent->d_name );
#endif /* _MSC_VER y/n */

   /* build fully qualified path to current entry,
      of the native platform type ... */
   sprintf( _dir_path, "%s%s%s",
      tdir->td_dirname,
      MY_SLASH,
      tdir->td_curr.de_name );

   /* set if entry is a directory */
   tdir->td_curr.de_isdir = MyDirExists( _dir_path );
   tdir->td_curr.de_size = g_stat_buf.st_size;
   tdir->td_curr.de_time = g_stat_buf.st_mtime;

   return( &tdir->td_curr );

}

void MyCloseDir( MyDir * tdir )
{
   if( tdir != NULL )
   {
#ifdef _MSC_VER
      if( tdir->td_hFind && ( tdir->td_hFind != INVALID_HANDLE_VALUE ) )
         FindClose( tdir->td_hFind );
      tdir->td_hFind = 0;
#else /* !_MSC_VER */
      if( tdir->td_pdir )
         closedir( tdir->td_pdir );
      tdir->td_pdir = NULL;
#endif
      free(tdir);
   }
}

void pgm_exit( int val )
{
   exit(val);
}
void show_help( char * prog )
{
   printf( "%s [switches] <directory>\n", prog );
   printf( "Switches: -? this help\n");
   printf( "          -x to delete\n");
}

void give_help( char * prog )
{
   show_help(prog);
   pgm_exit(0);
}

PMYLIST  g_pPATHS = 0;
PMYLIST  g_pFILES = 0;

void  add_2_end( PMYLIST head, PMYLIST nxt )
{
   PMYLIST  pn;
   if( head ) {
      pn = head->pnext;
      while(pn) {
         head = pn;
         pn = head->pnext;
      }
      head->pnext = nxt;
   }
}

void  add_2_list( PMYLIST * pList, char * path )
{
   PMYLIST head = *pList;
   PMYLIST nxt = malloc( sizeof(MYLIST) + strlen(path) );
   CHKMEM(nxt);
   nxt->done = 0;
   nxt->pnext = 0;
   strcpy(nxt->name, path);
   if( head ) {
      add_2_end( head, nxt );
   } else {
      *pList = nxt;
   }
}

void  add_2_paths( char * path )
{
   add_2_list( &g_pPATHS, path );
}
void  add_2_files( char * path )
{
   add_2_list( &g_pFILES, path );
}

void process_dir( char * dir )
{
   MyDirEnt * de;
   MyDir * pdir = MyOpenDir(dir);
   char * nxt = malloc( MY_NAME_MAX );
   CHKMEM(nxt);
   if( !pdir ) {
      printf("ERROR: Failed to open directory %s ...\n", dir );
      pgm_exit(-1);
   }
   de = MyReadDir( pdir );
   while(de) {
      if( de->de_isdir ) {
         if( strcmp(de->de_name,".") && strcmp(de->de_name,"..") ) {
            strcpy(nxt, dir);
            strcat(nxt, MY_SLASH);
            strcat(nxt, de->de_name);
            add_2_paths(nxt);
            g_dir_count++;
         }
      } else {
            strcpy(nxt, dir);
            strcat(nxt, MY_SLASH);
            strcat(nxt, de->de_name);
            add_2_files(nxt);
            g_file_count++;
            g_total_size += de->de_size;
      }

      de = MyReadDir( pdir );
   }
   MyCloseDir( pdir );
   free(nxt);
}

int process_paths( void )
{
   int icnt = 0;
   PMYLIST head = g_pPATHS;
   PMYLIST  pn = head;
   while(pn) {
      head = pn;
      if( !head->done ) {
         head->done = 1;
         icnt++;
         process_dir( head->name );
      }
      pn = head->pnext;
   }
   return icnt;
}


int main( int argc, char * * argv )
{
   int      i;
   char * arg;

   if( argc < 2 ) {
      printf( "ERROR: Must input a directory to delete ...\n" );
      show_help(argv[0]);
      pgm_exit(-1);
   }
   for( i = 1; i < argc; i++ )
   {
      arg = argv[i];
      if( arg[0] == '-' ) {
         arg++;
         while(*arg) {
            int c = toupper(arg[0]);
            switch(c)
            {
            case '?':
               give_help( argv[0] );
               break;
            case 'X':
               g_do_delete = 1;
               break;
            default:
               printf( "ERROR: Invlid argument in %s ... exiting ...\n", argv[i] );
               pgm_exit(-1);
               break;
            }
            arg++;
         }
      } else {
         if( MyDirExists( arg ) ) {
            g_dir = strdup( arg );
         } else {
            printf( "ERROR: %s does not appear to be a DIRECTORY ...\n", arg );
            pgm_exit(-1);
         }
      }
   }

   if( g_dir == 0 ) {
      printf( "ERROR: Must input a directory to delete ...\n" );
      show_help(argv[0]);
      pgm_exit(-1);
   }

   process_dir( g_dir );
   process_paths();

   printf( "For the folder %s ...\n", g_dir );
   printf( "got %d folders, %d files, total size (approx) %u bytes ...\n",
      g_dir_count, g_file_count, g_total_size );

   pgm_exit(0);

   return 0;
}

// eof - xdelete.c
