
// xclean.c - perform a MSVC clean up, like clobnow.bat

#include "xdelete.h"
#include "xfnmatch.h"

//typedef struct tagCLEAN {
//   TCHAR * mask2;
//   DWORD count;
//}CLEAN, * PCLEAN;

// { "temp*", "*", 0 },
CLEAN clean_masks_OLD_NOT_USED[] = {
{ ".old", 0 },
{ ".bak", 0 },
{ ".obj", 0 },
{ ".err", 0 },
{ ".pdb", 0 },
{ ".lst", 0 },
{ ".pch", 0 },
{ ".ilk", 0 },
{ ".ncb", 0 },
{ ".plg", 0 },
{ ".opt", 0 },
{ ".idb", 0 },
{ ".aps", 0 },
{ ".sbr", 0 },
{ ".suo", 0 }, // add this HIDDEN file
{ 0 , 0 }
};

CLEAN clean_masks2[] = {
{ "*.old", 0 },
{ "*.bak", 0 },
{ "*.obj", 0 },
{ "*.err", 0 },
{ "*.pdb", 0 },
{ "*.lst", 0 },
{ "*.pch", 0 },
{ "*.ilk", 0 },
{ "*.ncb", 0 },
{ "*.plg", 0 },
{ "*.opt", 0 },
{ "*.idb", 0 },
{ "*.aps", 0 },
{ "*.sbr", 0 },
{ "*.suo", 0 }, // add this HIDDEN file
// FIX20080531 - add some MORE to CLEAN -cd[r] option - does NOT delete folders
{ "*.manifest", 0 },
{ "*.res", 0 },
{ "*.user", 0 },
{ "mt.dep", 0 },
{ "BuildLog.htm", 0 },
{ 0 , 0 }
};

#define  X_NAME_MAX  264
static TCHAR _s_cmpbuf[8 * X_NAME_MAX];
BOOL  BeginwithTEMP( PTSTR pfil )
{
   size_t len = strlen(pfil);
   if( len >= 4 ) {
      if( ( toupper(pfil[0]) == 'T' ) &&
          ( toupper(pfil[1]) == 'E' ) &&
          ( toupper(pfil[2]) == 'M' ) &&
          ( toupper(pfil[3]) == 'P' ) )
      {
         if( strcmpi( pfil, "Template" ) ) { // let this one through!!!
            return TRUE;
         }
      }
   }
   return FALSE;
}

// FIX20070815 - add to show 'internal' msvc -c clean item list - VERB5
void Add_Clean_Exts( PTSTR pb )
{
   PCLEAN pc = &clean_masks2[0]; // FIX20080723 - if clean (-cd[r]) add ALL
   int   cnt = 0;
   while( pc->mask2 ) {
      if(cnt) {
         strcat( pb, ", " );
      }
      strcat( pb, pc->mask2 );
      pc++;
      cnt++;
   }
   strcat( pb, ", and temp*.*, except 'template'" );
}

BOOL  IsCleanExt( PTSTR pext )
{
   PCLEAN pc = &clean_masks2[0]; // FIX20080723 - if clean (-cd[r]) add ALL
   while( pc->mask2 ) {
      if( strcmpi( pext, pc->mask2 ) == 0 ) {
         return TRUE;
      }
      pc++;
   }
   return FALSE;
}

BOOL  IsInCleanList2( PTSTR pf )
{
   PTSTR nf = _s_cmpbuf; // MemAlloc( 8 * X_NAME_MAX );
   PTSTR drv1 = &nf[0*X_NAME_MAX];
   PTSTR pth1 = &nf[1*X_NAME_MAX];
   PTSTR fil1 = &nf[2*X_NAME_MAX];
   PTSTR ext1 = &nf[3*X_NAME_MAX];
   *drv1 = 0; /* mainly for debug view */
   *pth1 = 0;
   *fil1 = 0;
   *ext1 = 0;
   _splitpath( pf, drv1, pth1, fil1, ext1 );
   if( BeginwithTEMP( fil1 ) ) {
      return TRUE;
   } else if( (strlen(ext1) == 4) && IsCleanExt( ext1 ) ) {
      return TRUE;
   }

   return FALSE;
}

BOOL  IsInCleanList( PTSTR pf )
{
   PCLEAN pc = &clean_masks2[0];
   while( pc->mask2 ) {
      if( fnmatch (pc->mask2, pf, FNM_NOESCAPE | FNM_CASEFOLD ) == 0 ) {
         if(VERB9) {
            sprtf( "Matched [%s], with [%s]"MEOR,
               pc->mask2,
               pf );
         }
         return TRUE;
      }
      pc++;
   }
   if( IsInCleanList2( pf ) ) {
      if(VERB9) {
         sprtf( "Matched [%s] in IsInCleanList2 (but NOT fnmatch???)"MEOR,
            pf );
      }
   }
   return FALSE;
}

// eof - xclean.c
