@setlocal
@REM 2011-11-03 updated
@REM 2011-04-22 - Buildme.bat for MASSIVE GDAL PROJECT
@REM If just adding something, then no need for KILLALL
@if "%~1x" == "x" goto GOTCMD

@if "%1x" == "KILLALLx" (
@set KILLALL=yes
) else (
@echo ERROR: Presently ONLY command is KILLALL!
@goto END
)

:GOTCMD
@set PROJ=libgdal
@set NCBFILE=%PROJ%.ncb
@set OUTFILE=temp-log.txt
@echo 2011-11-03 - build file for %PROJ% project
@set BGNTIME=%TIME%

@REM call chkinps %PROJ%

@if EXIST %NCBFILE% @del %NCBFILE% >nul 2>&1
@if EXIST %NCBFILE% (
:RPTERR
@echo .
@echo ERROR: Can NOT delete %NCBFILE%
@echo This suggest MSVC is still open on this project...
@echo Close MSVC before continuing...
@echo .
@pause
@if EXIST %NCBFILE% @del %NCBFILE% >nul 2>&1
@if EXIST %NCBFILE% goto RPTERR
)

@REM DO it ALL, ***OR*** part
@if "%KILLALL%x" == "yesx" (
@call killall NOPAUSE
) else (
@call clobnow NOPAUSE
@call delsln NOPAUSE
@del /Q bin\*.*
)

@echo Commence build... %TIME% >%OUTFILE%

@del *.dsp >>%OUTFILE% 2>&1

@set TEMPC=0

@set TEMPPROJ=%PROJ%
@echo Building project %TEMPPROJ%
@echo Building project %TEMPPROJ% >>%OUTFILE%

@call createdsp -v9 -@%PROJ%.inp
@REM @call amsrcs -d extra -r %PROJ%.inp
@if ERRORLEVEL 1 goto FAILED
@REM copy stuff ...
@REM @call copyit NOPAUSE
@call tempcb NOPAUSE
@if EXIST C:\GTools\perl\temp.createdsp03.pl.txt (
@copy C:\GTools\perl\temp.createdsp03.pl.txt temp.libgdal.txt > nul
)
@set /A TEMPC+=1

@REM - Create the applications, or two ...
@REM =========================================================

@for %%i in (gdal2ogr gdaldem gdal_translate gdalinfo ogrinfo dumpoverviews gdaladdo gdalasyncread gdalbuildvrt) do @(call :BLDONE %%i)

@for %%i in (gdalflattenmask gdallocationinfo gdalmanage gdalenhance gdaltindex gdaltorture gdaltransform gdalwarp) do @(call :BLDONE %%i)

@for %%i in (gdalwarpsimple gdal_contour gdal_grid gdal_rasterize)  do @(call :BLDONE %%i)

@for %%i in (ogr2ogr ogrdissolve ogrtindex multireadtest nearblack testepsg testreprojmulti test_ogrsf)  do @(call :BLDONE %%i)

@echo Built %TEMPC% projects >>%OUTFILE%

@REM =========================================================
@goto MSVC_LOAD

:BLDONE
@if "%1x" == "x" goto :EOF
@set TEMPPROJ=%1
@echo Building project %TEMPPROJ%
@echo Building project %TEMPPROJ% >>%OUTFILE%
@if NOT EXIST %TEMPPROJ%.inp goto NOINPUT
@call createdsp -v9 -@%TEMPPROJ%.inp
@if ERRORLEVEL 1 goto FAILED
@call tempcb NOPAUSE
@if NOT EXIST %TEMPPROJ%.dsp goto NODSP
@if EXIST C:\GTools\perl\temp.createdsp03.pl.txt (
@copy C:\GTools\perl\temp.createdsp03.pl.txt temp.%TEMPPROJ%.txt > nul
@echo copied C:\GTools\perl\temp.createdsp03.pl.txt temp.%TEMPPROJ%.txt >>%OUTFILE%
)
@set /A TEMPC+=1
@goto :EOF

:NOINPUT
@echo ERROR: Input file [%TEMPPROJ%.inp] missing! >>%OUTFILE%
@echo ERROR: Input file [%TEMPPROJ%.inp] missing!
@echo Only Ctrl+c to abort...
@pause
@goto NOINPUT

:NODSP
@echo ERROR: DSP file [%TEMPPROJ%.dsp] NOT created! >>%OUTFILE%
@echo ERROR: DSP file [%TEMPPROJ%.dsp] NOT created!
@echo Only Ctrl+c to abort...
@pause
@goto NODSP

:MSVC_LOAD
@REM - Now load into MSVC

@if NOT EXIST %PROJ%.dsw goto ERR1
@start %PROJ%.dsw

@call updinps %PROJ%

@echo Done %TIME% >>%OUTFILE%
@call elapsed %BGNTIME%
@goto END

:ERR1
@echo ERROR: NOT EXIST %PROJ%.dsw!
@goto END

:FAILED
@echo ERROR: amsrcs exited with ERRORLEVEL %ERRORLEVEL%... Project %TEMPPROJ%
@pause
@echo Only Ctrl+c to abort... exit...
@goto FAILED

:END
@endlocal
