@echo Zip up GDAL, for web publicaton...
@setlocal
@set TEMPVER=03
@REM TEMPVER=02 - 2011-11-04: re-compile, adding WMS, CURL dependence (removed network save!)
@REM TEMPVER=01 - first published
@set PROJ=gdal-1.8
@set TEMPZ1=%PROJ%-src-%TEMPVER%.zip
@set TEMPZ2=%PROJ%-lib-%TEMPVER%.zip
@set TEMPZ3=%PROJ%-bin-%TEMPVER%.zip
@set TEMPL1=exe-list.txt
@set TEMPL2=lib-list.txt

@if NOT EXIST %TEMPL1% goto NOEXE
@if NOT EXIST %TEMPL2% goto NOLIB

@set TEMPO=-a
@if EXIST %TEMPZ1% (
@set TEMPO=-u
@echo Doing an UPDATE...
)

@set NOPAUSE=no
@if "%1x" == "NOPAUSEx"  (
@set NOPAUSE=yes
)

@set SAVESET=

@set TEMPX=%TEMP%\TEMPEXC4.TXT
@if EXIST %TEMPX% goto GotEx
Call QSEX %TEMPX%
@if NOT EXIST %TEMPX% goto Err5
@echo *.zip >> %TEMPX%
@echo *.exe >> %TEMPX%
@echo *.lib >> %TEMPX%
@echo *.dll >> %TEMPX%
@echo *.exp >> %TEMPX%
@echo mt.dep >> %TEMPX%
@echo Buildlog.htm >> %TEMPX%
:GotEx

@call dirmin %TEMPL1%
@call DIRMIN %TEMPL2%
@echo Are the above LIST files up-to-date?
@echo Will start with a cleanup...
@echo Will create ZIPS %TEMPZ1% %TEMPZ2% %TEMPZ3%
@if "%NOPAUSE%x" == "nox" (
@echo *** CONTINUE? *** Only Crtl+c will ABORT. All others continue...
@pause
)

@echo Cleaning up...
@call clobnow

@set TEMPZ=%TEMPZ1%
@echo Zip the SOURCE, including build files, to %TEMPZ1%...
@cd ..
@call zip8 %TEMPO% -o -r -p -x@%TEMPX% msvc\%TEMPZ1% *.*
@cd msvc
@if EXIST %TEMPZ% (
@call dirmin %TEMPZ%
) else (
@echo ERROR: FAILED to create %TEMPZ%!
@goto END
)

@echo Zip the static library, to %TEMPZ2%...
@set TEMPZ=%TEMPZ2%
@REM call zip8 %TEMPO% -o %TEMPZ2% lib\*.*
@call zip8 %TEMPO% -o %TEMPZ2% @%TEMPL2%
@if EXIST %TEMPZ% (
@call dirmin %TEMPZ%
) else (
@echo ERROR: FAILED to create %TEMPZ%!
@goto END
)

@echo Zip the binaries, to %TEMPZ3%...
@set TEMPZ=%TEMPZ3%
@REM call zip8 %TEMPO% -o -x*.lib -x*.exp -x*.ilk -x*_D.* %TEMPZ3% bin\*.exe
@call zip8 %TEMPO% -o %TEMPZ3% @%TEMPL1%
@if EXIST %TEMPZ% (
@call dirmin %TEMPZ%
) else (
@echo ERROR: FAILED to create %TEMPZ%!
@goto END
)


@echo All done... now to publish it...
@call dirmin %TEMPZ1%
@call dirmin %TEMPZ2%
@call dirmin %TEMPZ3%
@echo Doing 'genzipindex' to get a table...
@call genzipindex %TEMPZ1% %TEMPZ2% %TEMPZ3% 
@goto END

:Err5
@echo ERROR: Can NOT get the 'exclude' file list...
@goto END

:NOEXE
@echo ERROR: No EXE list %TEMPL1%
@goto END

:NOLIB
@echo ERROR: No LIB list %TEMPL2%
@goto END


:END
@endlocal
